<?php
require __DIR__ . '/../src/auth.php';
require_login();
require __DIR__ . '/../vendor/autoload.php';
require __DIR__ . '/../src/db.php';

use Dompdf\Dompdf;

$reportId = (int)($_GET['id'] ?? 0);
if (!$reportId) { header('Location: dashboard.php'); exit; }

$stmt = $pdo->prepare('SELECT * FROM raw_reports WHERE id = ?');
$stmt->execute([$reportId]);
$report = $stmt->fetch();

if (!$report) { echo "Report not found"; exit; }

// fetch parsed bits to include in PDF
$pms = $pdo->prepare('SELECT * FROM pms_backlog WHERE report_id = ? ORDER BY count_value DESC');
$pms->execute([$reportId]);
$pmsRows = $pms->fetchAll();

$offline = $pdo->prepare('SELECT * FROM offline_rt1000 WHERE report_id = ?');
$offline->execute([$reportId]);
$offlineRows = $offline->fetchAll();

$cdr = $pdo->prepare('SELECT * FROM cdr_status WHERE report_id = ?');
$cdr->execute([$reportId]);
$cdrRows = $cdr->fetchAll();

$wakeup = $pdo->prepare('SELECT * FROM wakeup_errors WHERE report_id = ?');
$wakeup->execute([$reportId]);
$wakeupRows = $wakeup->fetchAll();

// Build HTML
ob_start();
?>
<html>
<head>
<meta charset="utf-8">
<style>
body{font-family: DejaVu Sans, Arial, sans-serif; font-size:12px;}
h2{font-size:16px;}
table{width:100%; border-collapse:collapse; margin-bottom:10px;}
th,td{border:1px solid #ccc; padding:6px; font-size:11px;}
th{background:#f2f2f2;}
</style>
</head>
<body>
<h2>Report: <?=htmlspecialchars($report['filename'])?></h2>
<p>Uploaded: <?=htmlspecialchars($report['uploaded_at'])?></p>

<h3>PMS Backlog</h3>
<table>
<thead><tr><th>Property ID</th><th>Name</th><th>Count</th></tr></thead>
<tbody>
<?php foreach($pmsRows as $r): ?>
<tr><td><?=htmlspecialchars($r['property_id'])?></td><td><?=htmlspecialchars($r['prop_name'])?></td><td><?=htmlspecialchars($r['count_value'])?></td></tr>
<?php endforeach; ?>
</tbody>
</table>

<h3>Offline RT1000</h3>
<table>
<thead><tr><th>Property ID</th><th>Name</th><th>RT Name</th></tr></thead>
<tbody>
<?php foreach($offlineRows as $r): ?>
<tr><td><?=htmlspecialchars($r['property_id'])?></td><td><?=htmlspecialchars($r['prop_name'])?></td><td><?=htmlspecialchars($r['rt_name'])?></td></tr>
<?php endforeach; ?>
</tbody>
</table>

<h3>Wakeup Errors</h3>
<table>
<thead><tr><th>Property ID</th><th>Property</th><th>Room</th><th>Attempts</th><th>Schedule</th><th>Wakeup</th><th>Status</th></tr></thead>
<tbody>
<?php foreach($wakeupRows as $r): ?>
<tr>
<td><?=htmlspecialchars($r['property_id'])?></td>
<td><?=htmlspecialchars($r['prop_name'])?></td>
<td><?=htmlspecialchars($r['room_number'])?></td>
<td><?=htmlspecialchars($r['attempts'])?></td>
<td><?=htmlspecialchars($r['schedule_time'])?></td>
<td><?=htmlspecialchars($r['wakeup_time'])?></td>
<td><?=htmlspecialchars($r['status_text'])?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

</body>
</html>
<?php
$html = ob_get_clean();

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("report_{$reportId}.pdf", ['Attachment' => 1]);
exit;
