<?php
require __DIR__ . '/../src/auth.php';
require_login();
$user = current_user();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Upload Report</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">Report System</a>
    <div>
      <span class="me-3">Hello, <?=htmlspecialchars($user['username'])?></span>
      <a href="dashboard.php" class="btn btn-sm btn-outline-secondary">Back to Dashboard</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="card shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">Upload Reports</h5>
    </div>
    <div class="card-body">
      <form action="parse.php" method="post" enctype="multipart/form-data">
        
        <div class="mb-4">
          <label class="form-label fw-bold">Option 1: Upload File (.txt or .json)</label>
          <input class="form-control" type="file" name="reportFile" accept=".txt,.json">
          <div class="form-text">You can upload a raw text log OR a JSON file containing multiple reports.</div>
        </div>
        
        <hr class="my-4">

        <div class="mb-3">
          <label class="form-label fw-bold">Option 2: Bulk Paste (Text or JSON)</label>
          <textarea class="form-control font-monospace" name="reportText" rows="15" 
                    placeholder='Paste one of the following:&#10;1. Raw Text Log&#10;2. Single JSON: { "serviceProvider": "...", "tables": ... }&#10;3. Bulk JSON List: [ { "serviceProvider": "A"... }, { "serviceProvider": "B"... } ]' 
                    style="font-size: 0.85rem; background-color: #f8f9fa;"></textarea>
        </div>

        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
             <a href="dashboard.php" class="btn btn-light me-2">Cancel</a>
             <button class="btn btn-primary px-5">Process Report(s)</button>
        </div>

      </form>
    </div>
  </div>
</div>
</body>
</html>