<?php
// public/view_wakeup.php
require __DIR__ . '/../src/auth.php';
require_login();
require __DIR__ . '/../src/db.php';

// Fetch All Wakeup Errors joined with Report details
$stmt = $pdo->query("
    SELECT t.*, r.service_provider, r.uploaded_at, r.filename 
    FROM wakeup_errors t
    JOIN raw_reports r ON t.report_id = r.id
    ORDER BY r.uploaded_at DESC, r.service_provider ASC
");
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>All Wakeup Errors</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>body{font-family:'Inter',sans-serif;background:#f3f6f9;}</style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark border-bottom" style="background: linear-gradient(90deg, #1e293b 0%, #334155 100%);">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php"><i class="bi bi-grid-1x2-fill me-2"></i> Report System</a>
    <div>
        <a href="dashboard.php" class="btn btn-sm btn-outline-light">Back to Dashboard</a>
    </div>
  </div>
</nav>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>All Wakeup Errors <span class="badge bg-secondary rounded-pill"><?= count($rows) ?></span></h3>
        <a href="export_wakeup_txt.php" class="btn btn-dark shadow-sm">
            <i class="bi bi-file-text me-2"></i> Export List to Text
        </a>
    </div>

    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">Provider</th>
                            <th>Uploaded</th>
                            <th>Prop ID</th>
                            <th>Property Name</th>
                            <th>Room</th>
                            <th>Att</th>
                            <th>Status</th>
                            <th class="text-end pe-3">Report</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if (empty($rows)): ?>
                        <tr><td colspan="8" class="text-center py-4 text-muted">No wakeup errors found.</td></tr>
                    <?php else: ?>
                        <?php foreach($rows as $r): ?>
                            <tr>
                                <td class="ps-3"><span class="badge bg-info text-dark"><?= htmlspecialchars($r['service_provider']) ?></span></td>
                                <td class="small text-muted"><?= htmlspecialchars($r['uploaded_at']) ?></td>
                                <td><?= htmlspecialchars($r['property_id']) ?></td>
                                <td><?= htmlspecialchars($r['prop_name']) ?></td>
                                <td class="fw-bold"><?= htmlspecialchars($r['room_number']) ?></td>
                                <td><?= htmlspecialchars($r['attempts']) ?></td>
                                <td class="text-danger small"><?= htmlspecialchars($r['status_text']) ?></td>
                                <td class="text-end pe-3">
                                    <a href="view_report.php?id=<?= $r['report_id'] ?>#wakeup" class="btn btn-sm btn-outline-primary py-0">View</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</body>
</html>